# Cuadro VIII.1
# Contrastes de independencia, medidas de asociacin y coeficiente de incertidumbre

########################################################
# Seccin modificable por el usuario
########################################################
# Lectura de la base de datos
datos<-read.csv2("Cuadro VIII.1.V.csv",encoding="latin1")

# Seleccin de las variables de inters
# Si se quiere realizar la prueba de Friedman 
# Las variables de inters deben seguir en estricto orden:
# Variable RESPUESTAS, FACTOR, BlOQUE
varInteres<-c("Respuesta","Da")

# Seleccin de las variables de agrupacin.
#varAgrupa<-NULL
varAgrupa<-c("Antibitico")

# Tipos de pruebas a realizar
#  1. Prueba chi-cuadrado.
#  2. Prueba G sin correccin de Williams.
#  3. Prueba G con correccin de Williams.
#  4. Prueba chi-cuadrado con correccin de Yates (slo para tablas 2x2).
#  5. Prueba "exacta" de Fisher (Slo para tablas 2x2), bilateral.
#  6. Prueba "exacta" de Fisher (Slo para tablas 2x2), unilateral: menor que.
#  7. Prueba "exacta" de Fisher (Slo para tablas 2x2), unilateral: mayor que.
#  8. Prueba ANOVA de Friedman.
#  9. Prueba de McNemar sin correccin de continuidad.
# 10. Prueba de McNemar con correccin de continuidad (slo para tablas 2x2).
# 11. Prueba de Cochran.
# 12. Medidas de asociacin.
# 13. Coeficiente de incertidumbre.
# 14. Pruebas de Cochran (sin correccin) (slo tablas 2x2xk).
# 15. Pruebas de Cochran y Mantel-Haenszel (con correccin) (slo tablas 2x2xk).
# 16. Clculo de las razones de riesgo por estrato (slo 2x2xk).
# 17. Pruebas Breslow & Day con la correccin de Tarone (slo 2x2xk).

pruebas<-c(1,12,13)

# Nombre del archivo de salida con los resultados.
nomSalida<-"Salida Cuadro VIII.1.V.txt"

########################################################
# Seccin que realiza el procedimiento
########################################################
require(vcd)

# Log-likelihood tests of independence & goodness of fit
# Does Williams' and Yates' correction
#
# G & q calculation from Sokal & Rohlf (1995) Biometry 3rd ed.
# TOI Yates' correction taken from Mike Camann's 2x2 G-test fn.
# GOF Yates' correction as described in Zar (2000)
# more stuff taken from ctest's chisq.test()
#
# ToDo:
# 1) Beautify
# 2) Add warnings for violations
# 3) Make appropriate corrections happen by default
#
# V3.3 Pete Hurd Sept 29 2001. phurd@ualberta.ca

g.test <- function(x, y = NULL, correct="none",
  p = rep(1/length(x), length(x)))
{
  DNAME <- deparse(substitute(x))
  if (is.data.frame(x)) x <- as.matrix(x)
  if (is.matrix(x)) {
    if (min(dim(x)) == 1) 
      x <- as.vector(x)
  }
  if (!is.matrix(x) && !is.null(y)) {
    if (length(x) != length(y)) 
      stop("x and y must have the same length")
    DNAME <- paste(DNAME, "and", deparse(substitute(y)))
    OK <- complete.cases(x, y)
    x <- as.factor(x[OK])
    y <- as.factor(y[OK])
    if ((nlevels(x) < 2) || (nlevels(y) < 2)) 
      stop("x and y must have at least 2 levels")
    x <- table(x, y)
  }
  if (any(x < 0) || any(is.na(x))) 
    stop("all entries of x must be nonnegative and finite")
  if ((n <- sum(x)) == 0) 
    stop("at least one entry of x must be positive")
  #If x is matrix, do test of independence
  if (is.matrix(x)) {
    #Test of Independence
    nrows<-nrow(x)
    ncols<-ncol(x)
    if (correct=="yates"){ # Do Yates' correction?
      if(dim(x)[1]!=2 || dim(x)[2]!=2) # check for 2x2 matrix
        stop("Yates' correction requires a 2 x 2 matrix")
      if((x[1,1]*x[2,2])-(x[1,2]*x[2,1]) > 0)
        {
          x[1,1] <- x[1,1] - 0.5
          x[2,2] <- x[2,2] - 0.5
          x[1,2] <- x[1,2] + 0.5
          x[2,1] <- x[2,1] + 0.5
        }
      else
        {
          x[1,1] <- x[1,1] + 0.5
          x[2,2] <- x[2,2] + 0.5
          x[1,2] <- x[1,2] - 0.5
          x[2,1] <- x[2,1] - 0.5
        }
    }

    sr <- apply(x,1,sum)
    sc <- apply(x,2,sum)
    E <- outer(sr,sc, "*")/n
      # calculate G
      g <- 0
      for (i in 1:nrows){
        for (j in 1:ncols){
          if (x[i,j] != 0) g <- g + x[i,j] * log(x[i,j]/E[i,j])
        }
      }
      q <- 1
      if (correct=="williams"){ # Do Williams' correction
        row.tot <- col.tot <- 0    
        for (i in 1:nrows){ row.tot <- row.tot + 1/(sum(x[i,])) }
        for (j in 1:ncols){ col.tot <- col.tot + 1/(sum(x[,j])) }
        q <- 1+ ((n*row.tot-1)*(n*col.tot-1))/(6*n*(ncols-1)*(nrows-1))
      }
      STATISTIC <- G <- 2 * g / q
      PARAMETER <- (nrow(x)-1)*(ncol(x)-1)
      PVAL <- 1-pchisq(STATISTIC,df=PARAMETER)
      if(correct=="none")
        METHOD <- "Log likelihood ratio (G-test) test of independence without correction"
      if(correct=="williams")
        METHOD <- "Log likelihood ratio (G-test) test of independence with Williams' correction"
      if(correct=="yates")
        METHOD <- "Log likelihood ratio (G-test) test of independence with Yates' correction"
  }
  else {
    # x is not a matrix, so we do Goodness of Fit
    METHOD <- "Log likelihood ratio (G-test) goodness of fit test"
    if (length(x) == 1) 
      stop("x must at least have 2 elements")
    if (length(x) != length(p)) 
      stop("x and p must have the same number of elements")
    E <- n * p
    
    if (correct=="yates"){ # Do Yates' correction
      if(length(x)!=2)
        stop("Yates' correction requires 2 data values")
      if ( (x[1]-E[1]) > 0.25) {
        x[1] <- x[1]-0.5
        x[2] <- x[2]+0.5
      }
      else if ( (E[1]-x[1]) > 0.25){
        x[1] <- x[1]+0.5
        x[2] <- x[2]-0.5
      }
    }
    names(E) <- names(x)
    g <- 0
    for (i in 1:length(x)){
      if (x[i] != 0) g <- g + x[i] * log(x[i]/E[i])
    }
    q <- 1
    if (correct=="williams"){ # Do Williams' correction
      q <- 1+(length(x)+1)/(6*n)
    }
    STATISTIC <- G <- 2*g/q
    PARAMETER <- length(x) - 1
    PVAL <- pchisq(STATISTIC, PARAMETER, lower = FALSE)
  }
  names(STATISTIC) <- "Log likelihood ratio statistic (G)"
  names(PARAMETER) <- "X-squared df"
  names(PVAL) <- "p.value"
  structure(list(statistic=STATISTIC,parameter=PARAMETER,p.value=PVAL,
            method=METHOD,data.name=DNAME, observed=x, expected=E),
            class="htest")
}

# Autor: Marc Schwartz
cochranq.test <- function(mat)
{
  k <- ncol(mat)

  C <- sum(colSums(mat) ^ 2)
  R <- sum(rowSums(mat) ^ 2)
  T <- sum(rowSums(mat))


  num <- (k - 1) * ((k * C) - (T ^ 2))
  den <- (k * T) - R

  Q <- num / den

  df <- k - 1
  names(df) <- "df"
  names(Q) <- "Cochran's Q"

  p.val <- pchisq(Q, df, lower = FALSE)

  QVAL <- list(statistic = Q, parameter = df, p.value = p.val,

               method = "Cochran's Q Test for Dependent Samples",
               data.name = deparse(substitute(mat)))

  class(QVAL) <- "htest"
  return(QVAL)
} 

Uncertainty.coefficients<-function(tbl){
  sumX<-apply(tbl,1,sum)
  sumY<-apply(tbl,2,sum)
  sumT<-sum(tbl)
  Iy<- (-sum(sumY/sumT*log(sumY/sumT)))
  Ix<- (-sum(sumX/sumT*log(sumX/sumT)))
  Ixy<- (-sum(tbl/sumT*log(tbl/sumT)))
  Iydx <- (Ix+Iy-Ixy)/Iy
  Ixdy <- (Ix+Iy-Ixy)/Ix
  Iind <- 2*(Ix+Iy-Ixy)/(Ix+Iy)
  UI<-list(Iydx=Iydx,Ixdy=Ixdy,Iind=Iind)
  class(UI)<-"UncertCoef"
  return(UI)
}

print.UncertCoef<-function(UI){
  cat("Uncertainty coefficents or Theil's Uncertainty\n")
  cat("X:  ",UI$Iydx,"\n")
  cat("Y:  ",UI$Ixdy,"\n")
  cat("X|Y:",UI$Iind,"\n")
}

cmh1.test<-function (x) 
{
    pooled = apply(x, 1:2, sum)
    OR = pooled[1, 1] * pooled[2, 2]/pooled[1, 2]/pooled[2, 1]
    k = dim(x)[3]
    n11k = x[1, 1, ]
    n21k = x[2, 1, ]
    n12k = x[1, 2, ]
    n22k = x[2, 2, ]
    ORK = x[1, 1, ] * x[2, 2, ]/x[1, 2, ]/x[2, 1, ]
    row1sums = n11k + n12k
    row2sums = n21k + n22k
    col1sums = n11k + n21k
    n = apply(x, 3, sum)
    u11 = row1sums * col1sums/n
    var11 = as.numeric(row1sums) * as.numeric(row2sums) * as.numeric(col1sums) * (n - as.numeric(col1sums))/(n^2)/(n - 1)
    num = (sum(n11k - u11))^2
    deno = sum(var11)
    cmh = num/deno
    cmh.p.value = 1 - pchisq(cmh, 1)
    DNAME = deparse(substitute(x))
    METHOD = "Cochran-Mantel-Haenszel Chi-square Test"
    s.diag <- sum(x[1, 1, ] * x[2, 2, ]/n)
    s.offd <- sum(x[1, 2, ] * x[2, 1, ]/n)
    MH.ESTIMATE <- s.diag/s.offd
    orkname = paste("Odd Ratio of level", 1:k)
    PARAMETER = c(cmh, 1, cmh.p.value, MH.ESTIMATE, OR, ORK)
    names(PARAMETER) = c("CMH statistic", "df", "p-value", "MH Estimate", 
        "Pooled Odd Ratio", orkname)
    structure(list(parameter = PARAMETER, method = METHOD, data.name = DNAME), 
        class = "htest")
}


######################################################################
# Function to perform the Breslow and Day (1980) test including
# the corrected test by Tarone
# Uses the equations in Lachin (2000) p. 124-125.
#
# Programmed by Michael Hoehle <http://www-m4.ma.tum.de/pers/hoehle>
# Note that the results of the Tarone corrected test do
# not correspond to the numbers in the Lachin book...
#
# Params:
#  x - a 2x2xK contingency table
#
# Returns:
#  a vector with three values
#   1st value is the Breslow and Day test statistic
#   2nd value is the correct test by Tarone
#   3rd value - p value based on the Tarone test statistic
#               using a \chi^2(K-1) distribution
######################################################################

breslowday.test <- function(x) {
  #Find the common OR based on Mantel-Haenszel
  or.hat.mh <- mantelhaen.test(x)$estimate
  #Number of strata
  K <- dim(x)[3]
  #Value of the Statistic
  X2.HBD <- 0
  #Value of aj, tildeaj and Var.aj
  a <- tildea <- Var.a <- numeric(K)
  
  for (j in 1:K) {
    #Find marginals of table j
    mj <- apply(x[,,j], MARGIN=1, sum)
    nj <- apply(x[,,j], MARGIN=2, sum)

    #Solve for tilde(a)_j
    coef <- c(-mj[1]*nj[1] * or.hat.mh, nj[2]-mj[1]+or.hat.mh*(nj[1]+mj[1]),
                 1-or.hat.mh)
    sols <- Re(polyroot(coef))
    #Take the root, which fulfills 0 < tilde(a)_j <= min(n1_j, m1_j)
    tildeaj <- sols[(0 < sols) &  (sols <= min(nj[1],mj[1]))]
    #Observed value
    aj <- x[1,1,j]
    
    #Determine other expected cell entries
    tildebj <- mj[1] - tildeaj
    tildecj <- nj[1] - tildeaj
    tildedj <- mj[2] - tildecj

    #Compute \hat{\Var}(a_j | \widehat{\OR}_MH)
    Var.aj <- (1/tildeaj + 1/tildebj + 1/tildecj + 1/tildedj)^(-1)

    #Compute contribution
    X2.HBD <- X2.HBD + as.numeric((aj - tildeaj)^2 / Var.aj)

    #Assign found value for later computations
    a[j] <- aj ;  tildea[j] <- tildeaj ; Var.a[j] <- Var.aj
  }

  #Compute Tarone corrected test
  X2.HBDT <-as.numeric( X2.HBD -  (sum(a) - sum(tildea))^2/sum(Var.aj) )

  #Compute p-value based on the Tarone corrected test
  p <- 1-pchisq(X2.HBDT, df=K-1)

  res <- list(X2.HBD=X2.HBD,X2.HBDT=X2.HBDT,p=p)
  class(res) <- "bdtest"
  return(res)
}

print.bdtest <- function(x) {
  cat("Breslow and Day test (with Tarone correction):\n")
  cat("Breslow-Day X-squared         =",x$X2.HBD,"\n")
  cat("Breslow-Day-Tarone X-squared  =",x$X2.HBDT,"\n\n")
  cat("Test for test of a common OR: p-value = ",x$p,"\n\n")
}



tablaDobleEntrada<-function(datos,varInteres,pruebas,varEstratos=NULL){
  tbl1<-table(datos[,varInteres])
  listaPruebas<-NULL
  for (i in pruebas){
    if (i==1) listaPruebas<-c(listaPruebas,list(chisq.test(tbl1,correct=FALSE)))
    if (i==2) listaPruebas<-c(listaPruebas,list(g.test(tbl1)))
    if (i==3) listaPruebas<-c(listaPruebas,list(g.test(tbl1,correct="williams")))
    if (i==4) listaPruebas<-c(listaPruebas,list(chisq.test(tbl1,correct=TRUE)))
    if (i==5) listaPruebas<-c(listaPruebas,list(fisher.test(tbl1)))
    if (i==6) listaPruebas<-c(listaPruebas,list(fisher.test(tbl1,alternative="less")))
    if (i==7) listaPruebas<-c(listaPruebas,list(fisher.test(tbl1,alternative="greater")))
    if (i==8) {
              datos<-datos[,varInteres]
              tbl1<-tapply(datos[,1],datos[,2],mean)
              tbl1<-cbind(tbl1,tapply(datos[,1],datos[,2],sd))
              tbl1<-as.table(tbl1)
              colnames(tbl1)<-c("medias","desv.est")
              rownames(tbl1)<-paste(names(datos)[2],row.names(tbl1))
              varInt<-datos[,1]
              varFact<-datos[,2]
              varBloque<-datos[,3]
              listaPruebas<-c(listaPruebas,list(friedman.test(varInt,factor(varFact),factor(varBloque))))
              }
     if (i==9) listaPruebas<-c(listaPruebas,list(mcnemar.test(tbl1,correct=FALSE)))
     if (i==10) listaPruebas<-c(listaPruebas,list(mcnemar.test(tbl1,correct=TRUE)))
     if (i==11){ 
               datos<-datos[,varInteres]
               niv1<-levels(datos[,1])[1]
               niv2<-levels(datos[,1])[2]
               datos<-(datos==niv1)*1
               total<-apply(datos,2,length)
               tbl1<-apply(datos,2,sum)/total*100
               tbl1<-cbind(tbl1,100-tbl1)
               colnames(tbl1)<-c(paste("Porcentaje",niv1),paste("Porcentaje",niv2))
               listaPruebas<-c(listaPruebas,list(cochranq.test(datos)))
               }
     if (i==12) listaPruebas<-c(listaPruebas,list(assocstats(tbl1)))
     if (i==13) listaPruebas<-c(listaPruebas,list(Uncertainty.coefficients(tbl1)))
     if (i==14){
               varInt<-c(varInteres,varEstratos)
               datos<-datos[,varInt]
               tbl1<-as.array(table(datos))
               listaPruebas<-c(listaPruebas,list(mantelhaen.test(tbl1,correct=FALSE)))
               }
     if (i==15){
               varInt<-c(varInteres,varEstratos)
               datos<-datos[,varInt]
               tbl1<-as.array(table(datos))
               listaPruebas<-c(listaPruebas,list(mantelhaen.test(tbl1,correct=TRUE)))
               }
     if (i==16){
               varInt<-c(varInteres,varEstratos)
               datos<-datos[,varInt]
               tbl1<-as.array(table(datos))
               listaPruebas<-c(listaPruebas,list(cmh1.test(tbl1)))
               }
     if (i==17){
               varInt<-c(varInteres,varEstratos)
               datos<-datos[,varInt]
               tbl1<-as.array(table(datos))
               listaPruebas<-c(listaPruebas,list(breslowday.test(tbl1)))
               }

  }
  return(list(tabla=tbl1,listaPruebas=listaPruebas))
}

if (length(varInteres)!=2 & !any((c(8,11) %in% pruebas))) stop("Deben ser exactamente dos variables de inters")
if (length(varInteres)!=3 & (8 %in% pruebas)) stop("Para la prueba de Friedman se deben tener TRES variables: Rta, Factor y Bloque")
if (sum(varInteres %in% varAgrupa)>0) stop("Las variables de inters deben ser diferentes a las de agrupacin")
if (any(c(14,15) %in% pruebas) & is.null(varEstratos)) stop("Para la prueba de Cochran Mantel-Heanszel se necesita la variable estatificacin")

if (is.null(varAgrupa)){ 
    listaR<-tablaDobleEntrada(datos,varInteres,pruebas,varEstratos)
}else{
    lista1<-split(datos,datos[,varAgrupa])
    listaR<-lapply(lista1,tablaDobleEntrada,varInteres,pruebas,varEstratos)
}

if(!is.null(nomSalida)){
 sink(nomSalida)
 print(listaR)
 sink()
}

########################################################
# Seccin que muestra los resultados
########################################################


listaR
